﻿package devarai.games.searchPuzzle {
	
	import flash.utils.Dictionary;
	import devarai.games.searchPuzzle.menu.Menu;
	/**
	 * This is an interface for the SearchPuzzle class.
	 * @see SearchPuzzle
	 * @see SearchTable
	 */
	public interface ISearchPuzzle {
		
		/**
		 * The width of the puzzle
		 */
		function get puzzleWidth():uint;
		/**
		 * The height of the puzzle
		 */
		function get puzzleHeight():uint;
		/**
		 * List of words placed in the puzzle
		 */
		function get wordsPlaced():Vector.<String>;
		/**
		 * x increment helper.
		 */
		function get inc_x():Dictionary;
		/**
		 * y increment helper. I.e. "s" == south => +1
		 */
		function get inc_y():Dictionary;
		/**
		 * A reference to the mnue allowing to select and display the words.
		 */
		function get menu():Menu;
		/**
		 * The basic data structure for the search table. puzzleWidth X puzzleHeight
		 */
		function get table():Vector.<Vector.<String>>;
		
	}
	
}