﻿package devarai.games.searchPuzzle {
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	/**
	 * Class used as an element of the search grid. This object holds one character of the search grid. 
	 * @see SearchTable
	 */
	public class TableCell extends MovieClip {
		
		/**
		 * General size of such a square.
		 */
		public static var size:int = 25;
		/**
		 * The character.
		 */
		private var char:TextField;
		
		/**
		 * Formating and dummy beckground
		 */
		private var tfo:TextFormat;
		private var background:Sprite = new Sprite();
		
		/**
		 * Constructor.
		 * @param _char The character of this grid element.
		 */
		public function TableCell(_char:String) {

			char = new TextField();
			
			tfo = new TextFormat("_sans",18,0x000000,null,null,null,null,null,"center");
			
			char.text = _char;
			char.setTextFormat(tfo);
			char.selectable = false;
			this.mouseChildren = false;
			background.graphics.beginFill(0xffffff,0.05);
			background.graphics.drawRect(0,0,size,size);
			background.graphics.endFill();
			
			this.addChild(background);
			this.addChild(char);
			
			var rect:Rectangle = null;
			
			rect = char.getCharBoundaries(0);
						
			char.width = rect.width+4;
			char.height = rect.height+4;
			char.x = size/2-char.width/2;
			char.y = size/2-char.height/2;
			
		}
		
		
	}
	
	
}