﻿package devarai.games.searchPuzzle {
	import fl.transitions.Tween;
	
	import flash.geom.Rectangle;
	import fl.transitions.Tween;
	import fl.transitions.easing.Regular;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.events.Event;
	import flash.display.Graphics;
	import fl.transitions.easing.None;
	
	
	public class LearningTextField extends MovieClip {
		
		private var tf1:TextField = new TextField();
		
		private var tfor:TextFormat = new TextFormat("_sans",15,0x000000,null,null,null,null,null,"left");
		
		
		/**
		 * The following variables are used for masking the textfield
		 */
		private var masking:Sprite = new Sprite();
		
		private var mouseScrollL_mc:MouseScroll = new MouseScroll();
		private var mouseScrollR_mc:MouseScroll = new MouseScroll();
		
		private var myRect:Sprite;
		private var fadl:Sprite;
		private var fadr:Sprite;

		/**
		 * @private
		 */
		public var myScrollH : Number = 0;

		private var newScrollH : Number  = 0;

		private var scrollTween : Tween;
		private var maxScroll : Number =0;

		/**
		 * Tween for scrolling.
		 */
		private var sMTween1:Tween;
		private var sMTween2:Tween;

		
		private function drawTransRect(left:Boolean, right:Boolean):void {
			
			var xstart:Number =  tf1.x;
			var xwid:Number = tf1.width;
			
			if (!left) {
				xstart = fadl.x+fadl.width-2;
				
			} 
			if (!right) { 
				xwid = fadr.x-xstart+1;	
			}
			
			myRect.x = xstart; 
			myRect.width =  xwid+2;
			
		}
		
		
		
		/**
		 * Constructor.
		 * @param wid Width of the textfield in pixels.
		 */
		public function LearningTextField(wid:Number) {
			tf1.selectable = false;
			tf1.width  = wid;
			
			tf1.height = 25;
			
			this.addChild(tf1);
			//mouseScrollL_mc.alpha = 0.0;
			//mouseScrollR_mc.alpha = 0.0;
			
			
			this.addChild(mouseScrollL_mc);
			this.addChild(mouseScrollR_mc);
			
			mouseScrollL_mc.addEventListener("passOnKey",scrollMouseL);
			mouseScrollL_mc.init(false);
			mouseScrollR_mc.addEventListener("passOnKey",scrollMouseR);
			mouseScrollR_mc.init(true);
			
			
						
			myRect = new Sprite();
			
			var grafik : Graphics = myRect.graphics;
			grafik.beginFill(0x000000);
			grafik.drawRect(0,0,10,10);
			grafik.endFill();
			
			myRect.y = tf1.y;
			myRect.width = 0;
			myRect.cacheAsBitmap = true;
			
			fadl = mouseScrollL_mc.getFaderL();
			fadr = mouseScrollR_mc.getFaderR();
			
			
			masking.addChild(fadl);
			masking.addChild(fadr);
			masking.addChild(myRect);
			
			this.addChild(masking);
			masking.cacheAsBitmap = true;
			
			mouseScrollL_mc.x = tf1.x+7;
			mouseScrollL_mc.y = tf1.y+tf1.height/2-1;
			mouseScrollR_mc.x = tf1.width-7;
			mouseScrollR_mc.y = tf1.y+tf1.height/2-1;
					
					
			fadr.x = tf1.width-fadl.width;
			fadr.y = -1;
			fadl.x = 0;
			fadl.y = -1;
			
			
			fadr.height = tf1.height;
			fadl.height = tf1.height;
			
			myRect.height = tf1.height;
			
			fadl.width = ((fadl.width)<(tf1.width-2)*3.0/9) ? fadl.width : (tf1.width-2)*3.0/9;
			var oldwid:Number = fadr.width;
			fadr.width = (fadr.x>tf1.width - (tf1.width-2)*3.0/9) ? fadr.width : Math.abs(tf1.width-2)*3.0/9;
			fadr.x+=oldwid-fadr.width;
			
			tf1.mask = masking;
			tf1.cacheAsBitmap = true;
			
		
		}
		
		public function set text(s:String):void {
			tf1.text = s;
			tf1.setTextFormat(this.tfor);
			doScrolling();
		}
		
		/**
		 * Triggered if someone clicks on the scroll left arrow.
		 */
		private function scrollMouseL(evt:Event):void {
			
		
			newScrollH-=60;
			doScrolling();
			
			
		}
		/**
		 * Triggered if someone clicks on the scroll right arrow button.
		 */
		private function scrollMouseR(evt:Event):void {
			
			newScrollH+=60;
			doScrolling();
		}
		
		/**
		 * Does the scrolling if necessary.
		 */
		private function doScrolling():void {

			var maxrect:Rectangle = null;
			var end:int = tf1.length-1;
			var textW :Number = tf1.width;		
			
			
			if (newScrollH<0) newScrollH = 0;
			
			while (end>=0 && maxrect == null) { maxrect = tf1.getCharBoundaries(end); end--; }
			
			if (maxrect != null) {
				if (newScrollH>maxrect.x+maxrect.width-textW) {
					newScrollH = maxrect.x+maxrect.width-textW+10;
				}
				if (maxrect.x+maxrect.width <= textW) newScrollH = 0;
			}
			
						
				
			
			if (newScrollH>0) {
				if (sMTween1) sMTween1.stop();
				mouseScrollL_mc.visible = true;
				sMTween1 = new Tween(mouseScrollL_mc, "alpha", None.easeIn, mouseScrollL_mc.alpha,1,0.4,true);
				fadeLeftArrowOut = false;
			} else {
				if (!fadeLeftArrowOut) {
					if (sMTween1) sMTween1.stop();
					sMTween1 = new Tween(mouseScrollL_mc, "alpha", None.easeIn, mouseScrollL_mc.alpha,0,0.4,true);
					sMTween1.addEventListener("motionFinish",setLArrowInvis);
					fadeLeftArrowOut =  true;
				}
			}
			if (maxrect != null) {
				var maxScroll:Number = maxrect.x+maxrect.width+4;//-3.333;
				if (newScrollH<maxScroll-textW) {
					if (sMTween2) sMTween2.stop();
					mouseScrollR_mc.visible = true;
					sMTween2 = new Tween(mouseScrollR_mc, "alpha", None.easeIn, mouseScrollR_mc.alpha,1,0.4,true);
					fadeRightArrowOut = false;
				} else {
					if (!fadeRightArrowOut) {
						if (sMTween2) sMTween2.stop();
						sMTween2 = new Tween(mouseScrollR_mc, "alpha", None.easeIn, mouseScrollR_mc.alpha,0,0.4,true);
						sMTween2.addEventListener("motionFinish",setRArrowInvis);
						fadeRightArrowOut = true;
					}
				}
				drawTransRect(newScrollH<=0, newScrollH>=maxScroll-textW);
			} else {
				if (!fadeRightArrowOut) {
					if (sMTween2) sMTween2.stop();
					sMTween2 = new Tween(mouseScrollR_mc, "alpha", None.easeIn, mouseScrollR_mc.alpha,0,0.4,true);
					sMTween2.addEventListener("motionFinish",setRArrowInvis);
					fadeRightArrowOut = true;
				}
				drawTransRect(newScrollH<=0, false);
			}

			
			if ( (myScrollH < (newScrollH) || myScrollH > (newScrollH) || newScrollH == 0)) {
				
				if (scrollTween != null) scrollTween.stop();  
				scrollTween = new Tween(this,"myScrollH",Regular.easeOut,this.myScrollH,newScrollH,0.4,true);
				scrollTween.addEventListener("motionChange",uebernehmeScrollH);
				
				
			} 

		}
		
		
		private function setLArrowInvis(evt:Event):void {
			mouseScrollL_mc.visible = false;
		}
		private function setRArrowInvis(evt:Event):void {
			mouseScrollR_mc.visible = false;
		}
		
		
		private var fadeLeftArrowOut: Boolean = false;
		private var fadeRightArrowOut: Boolean = false;
		
		
		private function uebernehmeScrollH(evt:Event):void {
			tf1.scrollH = myScrollH;
		}



	}
	
	
}