﻿package devarai.games.searchPuzzle {
	
	/**
	 * Word Search Puzzle Games V.1.0
	 * By DEVARAI 2010, Henning Dierolf
	 * www.devarai.com 
	 * henning@devarai.com
	 */
	
	import devarai.common.music.SmallPlayer;
	import devarai.games.searchPuzzle.ISearchPuzzle;
	import devarai.games.searchPuzzle.menu.Menu;
	import devarai.games.searchPuzzle.results.ResultsDialog;
	import devarai.games.searchPuzzle.welcome.WelcomeDialog;
	
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.ContextMenuEvent;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.net.navigateToURL;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.ui.ContextMenu;
	import flash.ui.ContextMenuItem;
	import flash.utils.Dictionary;
	import flash.xml.XMLDocument;
	
	/**
	 * This is the main class for the search puzzle. It handles everything from loading the XML, creating the 
	 * table/grid and handling user interaction (through the associated classes).
	 */
	public class SearchPuzzle extends MovieClip implements ISearchPuzzle {
		
		/**
		 * Entities used for loading and handling the external XML file with the puzzle parameters.
		 */
		private var _loader:URLLoader = new URLLoader();
		private var _request:URLRequest;
		private var _xml:XML = null;
		
		/**
		 * Text direction (-1 right-to-left, 1 left-to-right)
		 */
		private var _direction:int; 
		
		/**
		 * Color for hightlighting solutions
		 */
		private var _solvColor:int;
		
		/**
		 * This is a inner displayobject the puzzle takes place in.
		 */
		private var puzzleStage:MovieClip = new MovieClip();
		
		/**
		 * Says whether the players results have to be submitted to the backend
		 */
		private var _submitResults:Boolean = false;
				
		/**
		 * Width of the puzzle in characters.
		 */
		private var _puzzleWidth:int;
		/**
		 * Height of the puzzle in characters.
		 */
		private var _puzzleHeight:int;
		/**
		 * All the words from the XML.
		 */
		private var words:Vector.<String>;
		
		/**
		 * The words filtered according to the valid alphabet.
		 */
		private var tableWords:Vector.<String>;
		/**
		 * Variable that identifies the difficulty of the game. ("beginner" or "advanced");
		 */
		private var _difficulty:String = "beginner";
		/**
		 * The words placed in the created puzzle and their info.
		 */
		private var _wordsPlaced:Vector.<String>
		private var _wordsPlaceInfo:Vector.<Array>;
		private var _tableWordsPlaced:Vector.<String>;
		/**
		 * A sentence or short text associated with a word used for reinforcement learning
		 */
		private var _wordsLearningText:Dictionary;
		/**
		 * The used alphabet. (relevant for creating random characters)
		 */
		private var alphabet:String;

		
		/**
		 * The puzzle grid.
		 */
		private var _table:Vector.<Vector.<String>>;

		/**
		 * x,y increment helpers.
		 */
		private var _inc_x:Dictionary = new Dictionary();
		private var _inc_y:Dictionary = new Dictionary();
		
		/**
		 * Displayobject to lay over the puzzle and fade dark
		 */
		private var fader:Sprite = new Sprite();

		/**
		 * Width of the whole puzzle in pixels.
		 */
		private var myWidth:Number;
		/**
		 * Height of the whole puzzle in pixels.
		 */
		private var myHeight:Number;
		/**
		 * The puzzle menu.
		 */
		private var _menu:Menu;
		/**
		 * Are we in exam mode ?
		 * 
		 */
		
		/**
		 * Songs
		 */
		public var playList:Array = new Array();
		
		private var _exam:Boolean = false;
		/**
		 *  Used for calculating the score
		 */
		private var _timeWeight:Number = 0.5;
		/**
		 * A search table class for handling the search table.
		 * @see SearchTable
		 */
		private var _searchTable:SearchTable;
		/**
		 * Do we have a time limit and how much is ? No time limit = "0"
		 */
		private var _timeLimit:Number = 0;
		
		/**
		 * Welcoming dialog to choose the difficulty,
		 */
		private var _welcomeDialog:WelcomeDialog;
		
		/**
		 * Message box class object.
		 */
		private var _learningTextBox:LearningText;

		/**
		 * ID String for this puzzle.
		 */
		private var _myId:String;
		
		/**
		 * Getter for the puzzle id.
		 */
		public function get theId():String {
			return this._myId;
		}
		
		/**
		 * Getter for the time limit
		 */
		public function get timeLimit():Number {
			return this._timeLimit;
		}
		
		/**
		 * Getter for the difficulty.
		 * @return "beginner" or "advanced".
		 */
		public function get difficulty():String {
			return this._difficulty;
		}
		
		/**
		 * Setter for the difficulty.
		 * @param s "beginner" or "advanced".
		 */
		public function set difficulty(s:String):void {
			this._difficulty = s;
		}
		
		/**
		 * Getter for the mode status
		 */
		public function get isExam():Boolean {
			return _exam;
		}
		
		/**
		 * @return The info for words placed in the puzzle.
		 */
		public function get wordsPlaceInfo():Vector.<Array> {
			return this._wordsPlaceInfo;
		}
		/**
		 * @return Increment x helper
		 */
		public function get inc_x():Dictionary {
			return this._inc_x;
		}
		/**
		 * @return Increment y helper
		 */
		public function get inc_y():Dictionary {
			return this._inc_y;
		}
		/**
		 * @return The puzzle grid. 
		 */
		public function get table():Vector.<Vector.<String>> {
			return this._table;
		}
		/**
		 * @return A reference to the search table object. 
		 */
		public function get searchTable():SearchTable {
			return this._searchTable;
		}
		/**
		 * @return A reference to the puzzle menu.
		 */
		public function get menu():Menu {
			return this._menu;
		}
		/**
		 * @return Width of the whole puzzle in pixels.
		 */
		override public function get width():Number {
			return this.myWidth;
		}
		/**
		 * @return Height of the whole puzzle in pixels.
		 */
		override public function get height():Number {
			return this.myHeight;
		}
		/**
		 * @return Width of the puzzle in characters.
		 */
		public function get puzzleWidth():uint {
			return this._puzzleWidth;
		}
		
		/**
		 * @return Height of the puzzle in characters.
		 */
		public function get puzzleHeight():uint {
			return this._puzzleHeight;
		}
		/**
		 * @return List of original words placed in the puzzle.
		 */
		public function get wordsPlaced():Vector.<String> {
			return this._wordsPlaced;
		}
		/**
		 * @return List of filtered words placed in the puzzle.
		 */
		public function get tableWordsPlaced():Vector.<String> {
			return this._tableWordsPlaced;
		}

		/**
		 * Do the player's results have to be submitted to the backend ?
		 */
		public function get submitResults():Boolean {
			return this._submitResults;
		}
		/**
		 * Factor for calculating the score
		 */
		public function get timeWeight():Number {
			return this._timeWeight;
		}
		/**
		 * This method is used to determine the reinforcement learning text for a particular word.
		 */
		public function get learningText():Dictionary {
			return this._wordsLearningText;
		}
		
		
		/**
		 * Class for showing a message box on the bottom
		 */
		public function get messageBox():LearningText {
			return this._learningTextBox;
		}
		
		private var _weHaveLearningText:Boolean = false;
		
		/**
		 * Says whether we have to apply reinforcement learning. 
		 */
		public function get isLearningText():Boolean {
			return this._weHaveLearningText;
		}

		private var context:ContextMenu;
		
		/**
		 * Constructor.
		 * @param _width The desired width in pixels.
		 * @param _height The desired height in pixels.
		 * @param _fileName The paramater XML file name+path.
		 */
		public function SearchPuzzle(_width:Number, _height:Number, _fileName:String) {
			
			context = new ContextMenu();
			
			
			var item:ContextMenuItem;
			
			
			item = new ContextMenuItem("Puzzle By Devarai");          
			item.addEventListener(ContextMenuEvent.MENU_ITEM_SELECT, navigate);
			context.customItems.push(item);		
				
			
			context.hideBuiltInItems();
			
			this.contextMenu = context;

		
			this.myWidth = _width;
			this.myHeight = _height;
			
			_inc_x["E"]=1;   _inc_y["E"]=0;
			_inc_x["S"]=0;   _inc_y["S"]=1;
			_inc_x["W"]=-1;  _inc_y["W"]=0;
			_inc_x["N"]=0;   _inc_y["N"]=-1;
			_inc_x["NE"]=1;  _inc_y["NE"]=-1;
			_inc_x["SE"]=1;  _inc_y["SE"]=1;
			_inc_x["SW"]=-1; _inc_y["SW"]=1;
			_inc_x["NW"]=-1; _inc_y["NW"]=-1;

			
			
			_request = new URLRequest(_fileName)
			
			_loader.load(_request);
			_loader.addEventListener(Event.COMPLETE, loadComplete, false, 0, true);
				
			this.fader.graphics.beginFill(0x000000,1);
			this.fader.graphics.drawRect(0,0,this.myWidth,this.myHeight);
			this.fader.graphics.endFill();

			this._welcomeDialog = new WelcomeDialog(this);
			
			this._welcomeDialog.x = this.myWidth/2;
			this._welcomeDialog.y = this.myHeight/2;
			this.addChild(this._welcomeDialog);
			

			this.addEventListener(Event.ADDED_TO_STAGE, checkaddy);
			

		}
		
		private function checkaddy(evt:Event):void {
			at1 = parent.getChildByName("title1") as TextField;
			
			at2 = parent.getChildByName("title2") as TextField;
			

		}
		
		/**
		 * Eventual added text fields for additional title
		 */
		private var at1:TextField;
		private var at2:TextField;
		
		private function navigate(evt:Event):void {
			var request:URLRequest = new URLRequest("http://activeden.net/user/Devarai?ref=Devarai");
			
			try {
				navigateToURL(request, "_blank"); // second argument is target
			} catch (e:Error) {
			}			
		}
			
		/**
		 * Called if the XML is loaded.
		 */
		private function loadComplete(e:Event):void {
			_xml= new XML(e.target.data);
			
			// Create the puzzle.
			
			if (_xml.additionalTitle.text().length()>0) {
				
				if (this.at2) {
					
					var tf:TextFormat = new TextFormat("Arial",18,0x222222,null,null,null,null,null,"left",null,null,null);
					tf.letterSpacing = 0.5;
					
					this.at2.text = _xml.additionalTitle.text();
					this.at2.setTextFormat(tf);
				}
				
			} else {
				if (this.at2) at2.visible = false;
				if (this.at1) at1.visible = false;	
			}

			// Read in the XML data
			
		}
		
		private var saveWords:Vector.<String>;
		private var saveTableWords:Vector.<String>;
		private var placeWords:Number = Number.MAX_VALUE;
		
		private var _specialClue:Array;
		public function get specialClue():Array {
			return _specialClue;
		} 
		
		public var musicPlayer = new SmallPlayer();
		
		/**
		 * Reads in the loaded XML data and starts the game.
		 */
		public function doInit():void {
			
			this.removeChild(this._welcomeDialog);
				
			while (_xml == null) {};
			

			alphabet = _xml.alphabet.text();
			
			_specialClue = new Array();

			var item:XML;

			this._myId = _xml.id.text();
			
			var songs:XMLList = _xml.elements("song");
			for each(item in songs) {
				this.playList.push(String(item.text()));
			}
			
			
			var wordsList:XMLList = _xml.elements("word");
			words = new Vector.<String>();
			tableWords = new Vector.<String>();
			
			saveWords = new Vector.<String>();
			saveTableWords = new Vector.<String>();
			
			
			this._wordsLearningText = new Dictionary();
			
			
			for each(item in wordsList) {
				saveWords.push(item.text());
				
				var tword:String = "";
				for (var k:int =  0; k<saveWords[saveWords.length-1].length; k++) {
					if (alphabet.lastIndexOf(saveWords[saveWords.length-1].charAt(k))!= -1) {
						tword=tword+saveWords[saveWords.length-1].charAt(k);
					}
				}
				saveTableWords.push(tword);
				
				if (item.attribute("info").length()>0) {
					this._wordsLearningText[""+tword] = String(item.attribute("info")[0]);
					this._weHaveLearningText = true;
				}
				if (item.attribute("clue").length()>0) {
					_specialClue[""+tword] = String(item.attribute("clue")[0]);
					
				}
			}
		
			var i,j:int;
			
			
			
			if (_xml.attribute("placeWords")[0]) {
			
				if (_xml.attribute("placeWords")[0]!="all") {
					this.placeWords = Number(_xml.attribute("placeWords")[0]);
				}				
			}
			
			if (_xml.attribute("menuWidth")[0]){
				var wid:Number = Number(_xml.attribute("menuWidth")[0]);
				if (wid) {
					Menu.myWidth = wid;
				}
			}
			
			if (_xml.attribute("cellDimensions")[0]){
				var dim:Number = Number(_xml.attribute("cellDimensions")[0]);
				if (dim) {
					TableCell.size = dim;
				}
			}
			trace(words.length);
	
			var maxPuzzleW:int = int.MAX_VALUE;
			var maxPuzzleH:int = int.MAX_VALUE;
			
			if (_xml.attribute("mode")[0] == "exam") {
				this._exam = true;
			}
			_timeLimit = Number(_xml.attribute("timeLimit")[0])
			
			if (_xml.attribute("width")[0] != "max") {
				maxPuzzleW =int(_xml.attribute("width")[0]);
			} 
			if (_xml.attribute("height")[0] != "max") {
				maxPuzzleH =int(_xml.attribute("height")[0]);
			} 
			var solvColor:int = int(_xml.attribute("solutionColor")[0]);

			var direction:int = (String(_xml.attribute("readingDirection")[0])=="rightToLeft")?-1:1;
			
			this._submitResults =  (String(_xml.attribute("submitResults")[0])=="true")?true:false;
			
			this._timeWeight = Number(_xml.attribute("timeWeight")[0]);
			
			
			this._direction = direction;
			this._solvColor = solvColor;
			
			_menu = new Menu(this,this.myHeight);
			puzzleStage.addChild(_menu);
			_menu.x = this.myWidth - menu.width;
			_menu.y = 6;
			
			this._learningTextBox = new LearningText(this.myWidth-menu.width-14,this);
			
			_puzzleWidth = Math.min(Math.floor((this.myWidth-_menu.width)/TableCell.size),maxPuzzleW);
			_puzzleHeight = Math.min(Math.floor((this.myHeight-this._learningTextBox.height)/TableCell.size),maxPuzzleH);
			
			_resultsDialog = new ResultsDialog(this);



			var indent:Number = Number(_xml.attribute("musicPlayerIndent")[0]);
			
			if (!indent) indent = 0;
			
			if (this.playList.length>0) {
				this.addChild(this.musicPlayer);
				musicPlayer.scaleX = 0.8;
				musicPlayer.scaleY = 0.8;
				musicPlayer.y -= 29;
				musicPlayer.x = myWidth-musicPlayer.width-13-indent-40;
			}	
			
			var vol:Number = Number(_xml.attribute("musicVolume")[0]);
			
			if (!vol) vol = 0;
			
			this.musicPlayer.init(this.playList,0,(String(_xml.attribute("autoPlayMusic")[0])=="true")?true:false,vol);
			
			
			if (!vol || this.playList.length == 0) {
				if (this.contains(musicPlayer)) this.removeChild(musicPlayer);
			}
			
			
			
			
			if (_xml.filter.text().length >3) {
				
				// Load the list for filtering
				_request = new URLRequest(_xml.filter.text());
				
				_loader.load(_request);
				_loader.addEventListener(Event.COMPLETE, loadFilterComplete, false, 0, true);
				
				
			} else {
				finishInit();
			}
			
		}
		
		private var filterWordsXML:XML;
		private var filterWords:Dictionary = new Dictionary();
		
		
		private function loadFilterComplete(evt:Event):void {

			
			filterWordsXML = new XML(evt.target.data);
			
			var wordsList:XMLList = filterWordsXML.elements("word");
			
			var item:XML;
			
			for each(item in wordsList) {
				filterWords[""+(item.text())] = true;
			}

			finishInit();

		}
		
		private function finishInit():void {

			createGame();
			
			if (this._weHaveLearningText) puzzleStage.addChild(this._learningTextBox);
			
			puzzleStage.alpha = 0;
			
			this.addChild(puzzleStage);
			
			initTw = new Tween(puzzleStage,"alpha",None.easeIn,0,1,1,true);
			
			
			_menu.addEventListener("done", gameEnd);
			
			_menu.timer.startTimer(this._timeLimit);

		}
		
		private var initTw:Tween = null;
		
		private function createGame():void {

			
			var i,j:int;
			
			this.words.splice(0,words.length);
			this.tableWords.splice(0,tableWords.length);


			for (i = 0; i<this.saveWords.length; i++) {
				this.words.push(this.saveWords[i]);
				this.tableWords.push(this.saveTableWords[i]);
			}
			

			while (words.length>this.placeWords) {
				var pos:int = Math.floor(Math.random()*words.length);
				words.splice(pos,1);
				tableWords.splice(pos,1);
			}


			this.calculateTable();
			
			
			
			// sort words placed entries according to alphabet 
			for (i = 0; i<_wordsPlaced.length-1; i++) {
				var minVX:String= _wordsPlaced[i];
				if (this._specialClue[""+_wordsPlaced[i]]!= null) {
					minVX=this._specialClue[""+_wordsPlaced[i]];
				}
				var minVi:int=i;
				for (j = i+1; j<_wordsPlaced.length; j++) {
					
					if (this._direction == 1) {
						
						if (this._specialClue[""+_wordsPlaced[j]]!= null) {
							if (minVX.localeCompare(this._specialClue[""+_wordsPlaced[j]])>0) { 
								minVi=j;
								minVX=this._specialClue[""+_wordsPlaced[j]];
							}
						} else {
							if (minVX.localeCompare(_wordsPlaced[j])>0) { 
								minVi=j;
								minVX=_wordsPlaced[j];
							}													
						}
						
					} else {
						for (var l:int = 1; l<=minVX.length; l++) {
							if (_wordsPlaced[j].length-l<0) break;
							var comp:int = minVX.charAt(minVX.length-l).localeCompare(_wordsPlaced[j].charAt(_wordsPlaced[j].length-l));
							if (comp>0) { 
								minVi=j;
								minVX=_wordsPlaced[j];
								break;
							}		
							if (comp<0) break;
						}
					}
				}
				var temp:String = _wordsPlaced[i];
				var tempA:Array = _wordsPlaceInfo[i];
				var tempB:String = _tableWordsPlaced[i];
				_wordsPlaced[i] = _wordsPlaced[minVi];
				_tableWordsPlaced[i] = _tableWordsPlaced[minVi];
				_wordsPlaceInfo[i]  = _wordsPlaceInfo[minVi];
				_wordsPlaced[minVi]=temp;
				_tableWordsPlaced[minVi]=tempB;
				_wordsPlaceInfo[minVi] = tempA;
			}
			
			//trace(_wordsPlaced);
			
			for (i = 0; i<this._wordsPlaced.length; i++) {
				_menu.addWord(_wordsPlaced[i],this._tableWordsPlaced[i]);
			}

			if (_searchTable) {
				if (oldSearchTable) if (puzzleStage.contains(oldSearchTable)) puzzleStage.removeChild(oldSearchTable);
				if (fadeOut) fadeOut.stop();
				oldSearchTable = _searchTable;
				fadeOut = new Tween(oldSearchTable,"alpha",None.easeIn,oldSearchTable.alpha,0,0.7,true);
				fadeOut.addEventListener("motionFinish", removeOld);
			}
			
			_searchTable = new SearchTable(this,_solvColor,_direction);
			
			_searchTable.alpha = 0;
			
			if (fadeInNewTable) fadeInNewTable.stop();
			
			fadeInNewTable = new Tween(_searchTable,"alpha",None.easeIn,_searchTable.alpha,1,0.5,true);
			
			puzzleStage.addChild(_searchTable);
			
			_searchTable.x = (this.myWidth-_menu.width)/2 -  _searchTable.width/2;
			_searchTable.y = (this.myHeight-this._learningTextBox.height)/2 -  _searchTable.height/2;	
			
			_searchTable.addEventListener("done", gameEnd);
			
			this._learningTextBox.init("Please try to solve the puzzle above.");
			
			

		}
		/**
		 * These variables are useful if we replay and have old stuff on the stage and have to remove them
		 */
		private var fadeOut:Tween;
		private var fadeInNewTable:Tween;
		private var oldSearchTable:SearchTable;
		
		/**
		 * Removes an old searchtable from the stage.
		 */
		private function removeOld(evt:Event):void {
			if (oldSearchTable) {
				puzzleStage.removeChild(oldSearchTable);
				this.oldSearchTable = null;
			}
		} 
		
		/**
		 * The results dialog window
		 */
		private var _resultsDialog:ResultsDialog;
		
		/**
		 * @private
		 */
		public var blurVal:Number;
		/**
		 * Tween for blurring out the puzzle
		 */
		private var blurTween:Tween;
		/**
		 * Filter for blurring
		 */
		private var blurFilter:BlurFilter = new BlurFilter(0,0,3);
		
		/**
		 * This method handles what has to be done if the game is over. So it displays i.e. the results dialog window.
		 * 
		 */
		private function gameEnd(evt:Event):void {
		
			this._menu.timer.stopTimer();
			this.fader.alpha = 0;
			this.addChild(fader);
			if (blurTween) blurTween.stop();
			blurTween = new Tween(this,"blurVal",None.easeIn,0,1,2.1,true);
			blurTween.addEventListener("motionChange", gameEndAdapt);
			blurTween.addEventListener("motionFinish",showResults);
		} 
		
		public function replay():void {
			this._menu.clear();
			this.createGame();
			if (blurTween) blurTween.stop();
			blurTween = new Tween(this,"blurVal",None.easeIn,blurVal,0,1.5,true);
			blurTween.addEventListener("motionChange", gameEndAdapt);
			blurTween.addEventListener("motionFinish",playGame);			
			_menu.timer.startTimer(this._timeLimit);
		}
		
		private function playGame(evt:Event):void {
			this.removeChild(fader);
			this.removeChild(this._resultsDialog);
			this.puzzleStage.filters = [];
		}
		
		private function gameEndAdapt(evt:Event):void {
			fader.alpha = blurVal*0.08;
			blurFilter.blurX = blurVal*8;
			blurFilter.blurY = blurVal*8;
			this.puzzleStage.filters = [blurFilter];
			
		}
		
		private function showResults(evt:Event):void {
			this._resultsDialog.x = this.myWidth/2;
			this._resultsDialog.y = this.myHeight/2;
			this.addChild(this._resultsDialog);
		}
			
		/**
		 * Creates an empty puzzle grid.
		 */
		private function createEmptyTable():Vector.<Vector.<String>> {
			var ret:Vector.<Vector.<String>> = new Vector.<Vector.<String>>()
			for (var i:int =0; i<puzzleWidth; i++) {
				var row:Vector.<String> = new Vector.<String>();
				ret.push(row);
				for (var j:int = 0; j<puzzleHeight; j++) {
					row.push("");
				}				
			}
			return ret;
		}
		
		/**
		 * @return A randomly shuffle list of possible directions.
		 */
		private function createRandomDirectionsList():Vector.<String> {
			var ret:Vector.<String> = new Vector.<String>();
			
			var directionsAdv:Array = ["S","W","E","N","NE","SW","NW","SE"];
			var directionsEasy:Array = ["E","S"];
			
			var directions:Array;
			
			if (this._difficulty == "beginner") {
				directions = directionsEasy;
			} else {
				directions = directionsAdv;
			}
			
			for (var i:int = 0; i<directions.length; i++) {
				
				var pos:int = Math.floor(Math.random()*directions.length);
				ret.push(directions[pos]);
				directions.splice(pos,1);
			}
			return ret;		
			
		}
		
		
		/**
		 * Creates the puzzle table with characters.
		 */
		private function calculateTable():void {
			
			var i,j,l,m:int;
			
			
			// sort words entries according to length 
			for (i = 0; i<words.length-1; i++) {
				var minVX:Number=-words[i].length;
				var minVi:int=i;
				for (j = i+1; j<words.length; j++) {
					if (minVX>-words[j].length) {
						minVi=j;
						minVX=-words[j].length;
					}
				}
				var temp:String=words[i];
				var temp2:String = tableWords[i];
				words[i] = words[minVi];
				tableWords[i] = tableWords[minVi];
				words[minVi]=temp;
				tableWords[minVi] = temp2;
			}

			
			// Define the increments for the 8 directions
			
			var max_attempts:int = 150;
			


			var temp_grid = this.createEmptyTable();

			var bestWordsPlaced : Vector.<String>;
			var bestTableWordsPlaced : Vector.<String>;
			var bestWordsPlaceInfo:Vector.<Array>;
			var bestTable:Vector.<Vector.<String>>;
			
			
			for (i = 0; i<15; i++) {
				_table = createEmptyTable();
				
				_wordsPlaced = new Vector.<String>();
				_tableWordsPlaced = new Vector.<String>()
				_wordsPlaceInfo = new Vector.<Array>();
				
				// loop through all the words 
				for (var k:int = 0; k<tableWords.length; k++) {
					var word:String = tableWords[k];
					var placed:Boolean = false;
					var tries:int = 0;
					while (!placed && tries < max_attempts) {
						var _x:int;
						var _y:int;
						_x=Math.floor(Math.random()*this.puzzleWidth); 
						_y=Math.floor(Math.random()*this.puzzleHeight);
						if (_table[_x][_y] == "" || _table[_x][_y] == word.substring(0,1)) {
							
							var dirList:Vector.<String> = this.createRandomDirectionsList();
							var direction:String;
							for (j=0; j<dirList.length && !placed; j++) {
								direction = dirList[j];
								for (l = 0; l<this.puzzleWidth; l++) {
									for (m = 0; m<this.puzzleHeight; m++) {
										temp_grid[l][m] = "";
									}
								}
								var position:int =  0;
								for (;position<word.length;position++) {
									var char:String = word.substring(position,position+1);
									var curr_x:int =_x+position*_inc_x[direction];
									var curr_y:int =_y+position*_inc_y[direction];
									if(curr_x<0 || curr_x>(this.puzzleWidth-1) || curr_y<0 || curr_y>(this.puzzleHeight-1)) { 
										break; 
									}
									// is the target cell empty?
									if (_table[curr_x][curr_y] == "") {
										temp_grid[curr_x][curr_y]=char;
									} else {
										// does the target cell contain the letter in question?
										if (_table[curr_x][curr_y] == char) {
											temp_grid[curr_x][curr_y]=char;
										} else {          
											break;
										}
									}
									//           
									if(position == word.length-1) { 
										for (l = 0; l<this.puzzleWidth; l++) {
											for (m = 0; m<this.puzzleHeight; m++) {
												if(temp_grid[l][m] == "") {
												} else {
													_table[l][m]= temp_grid[l][m];
												}
											}
										}
										placed=true;
										_wordsPlaced.push(words[k]);
										_tableWordsPlaced.push(word);
										_wordsPlaceInfo.push([_x,_y,direction]);
										
									}
								}
							}      
						}
						tries++;
					}
				
				}
				
				// select the best result
				
				if (bestTable == null) {
					bestWordsPlaceInfo = _wordsPlaceInfo;
					bestWordsPlaced = _wordsPlaced;
					bestTableWordsPlaced = _tableWordsPlaced;
					bestTable = _table;
				} else if (_wordsPlaced.length>bestWordsPlaced.length) {
					bestWordsPlaceInfo = _wordsPlaceInfo;
					bestWordsPlaced = _wordsPlaced;
					bestTableWordsPlaced = _tableWordsPlaced;
					bestTable = _table;
				}

				if (_wordsPlaced.length == words.length) break;
			}
			
			_table = bestTable;
			_wordsPlaced = bestWordsPlaced;
			_wordsPlaceInfo = bestWordsPlaceInfo;
			_tableWordsPlaced = bestTableWordsPlaced;
			
			for (l = 0; l<this._puzzleWidth; l++) {
				for (m = 0; m<this._puzzleHeight; m++) {
					var notAllowed:Boolean = false;
					if(_table[l][m] == "") {
						do {
							
							notAllowed = false;
							
							_table[l][m] = this.alphabet.charAt(Math.floor((Math.random()*this.alphabet.length)));
							
							var aw:String ="";
							var o,u:int;
							if (this._direction == 1) {
								for (o = l; o>=0; o--) {
									aw = _table[o][m]+aw;
									if (this.filterWords[""+aw]) {
										notAllowed = true;
										break;
									} 
								}
								aw = "";
								if (!notAllowed)
								for (o = m; o>=0; o--) {
									aw = _table[l][o]+aw;
									if (this.filterWords[""+aw]) {
										notAllowed = true;
										break;
									} 
								}
								
							} else 
							if (this._direction == -1) {
								for (o = 0; o<=l; o++) {
									aw = aw+_table[o][m];
									if (this.filterWords[""+aw]) {
										notAllowed = true;
										break;
									} 
								}		
								aw = "";
								if (!notAllowed)
								for (o = 0; o<=m; o++) {
									aw = aw+_table[l][o];
									if (this.filterWords[""+aw]) {
										notAllowed = true;
										break;
									} 
								}		
							}
							
							
						} while (notAllowed);
												
					}
				}
			}
			

/*			trace("\nWords placed:");
			for (var g:int = 0; g<this.wordsPlaced.length; g++) {
				trace(this._wordsPlaced[g]+" ("+_wordsPlaceInfo[g]+")");	
			}
*/		}
		
		
	}
	
}