﻿package devarai.games.searchPuzzle {
	import flash.display.BlendMode;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.utils.Dictionary;
	import flash.utils.Timer;
	
	/**
	 * This is the SearchTable class. It keeps track of the search table. That is the grid with all the 
	 * words and random characters in it. With this class you evaluate if a selection is a word 
	 * we are searching for ...
	 */
	public class SearchTable extends MovieClip {
		
		/**
		 * 
		 * Sound linked to lib.
		 */
		private var success:Success = new Success();
		private var failure:Fail = new Fail();
		private var gameEnd:GameEnd = new GameEnd();
		
		
		
		
		/**
		 * A reference to the main class.
		 */
		private var sp:SearchPuzzle;

		/**
		 * Markers and highlights for already solved words
		 */
		private var solved:Sprite = new Sprite();
		/**
		 * The layer for drawing a selection 
		 */
		private var select:Sprite;
		/**
		 * The color solved words are highlighted in.
		 */
		private var solvColor:int;
		/**
		 * The words that are already solved.
		 */
		private var shownWords:Dictionary = new Dictionary();
		
		/**
		 * left to right = 1, right to left = -1
		 */
		private var direction:int;
		
		/**
		 * The number of words the player solved without help
		 */
		private var _playerSolved:int = 0;
		
		/**
		 * Records how often the player clicked until the game was solved.
		 * This is an indicator for players who cheated using UI testing tools. 
		 */
		private var _clicks:Number = 0;
		
				
		/**
		 * Constructor.
		 * @param _sp The main class.
		 * @param solutionColor A color the solved words are hightlighted with
		 */
		public function SearchTable(_sp:SearchPuzzle, solutionColor:int, _direction:int) {
			this.sp = _sp;
			this.direction = _direction;
			solvColor = solutionColor;
			this.addChild(solved);
			drawTable();
			_playerSolved = 0;
			
			timer.addEventListener(TimerEvent.TIMER_COMPLETE,endSolutionWord); 
					
			select = new Sprite();
			this.addChild(select);
			this.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			this.addEventListener(Event.ADDED_TO_STAGE, addedToStage);
			this.addEventListener(Event.REMOVED_FROM_STAGE, removedFromStage);
			select.blendMode = BlendMode.INVERT;
		}
	
		/**
		 * How many clicks did the player have?
		 */
		public function get playerClicks():Number {
			return this._clicks;
		}
		
		/**
		 * The number of words the player solved without help
		 */		
		public function get playerSolved():int {
			return this._playerSolved;
		}
		
		/**
		 * Adds a mouse button up listener to the stage when available.
		 */
		private function addedToStage(evt:Event):void {
			
			stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp,false,0,true);
		}
		/**
		 * Cleans up if removed from stage.
		 */
		private function removedFromStage(evt:Event):void {
			stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUp);			
		}
		
		private var succ:SoundChannel;
		private var fail:SoundChannel;
		
		/**
		 * Called if the mouse button is released.
		 * So eventually the user has selected a valid solution word.
		 */
		private function mouseUp(evt:Event):void {
			this.removeEventListener(MouseEvent.MOUSE_MOVE, mouseMoved);	
			
			
			if (startX == -1 || startY == -1) return;
			
			var i,j:int;
			
			var s:String = "";
			
			var si,sj,ei,ej:int;
			
			si=  Math.floor(startX/TableCell.size);
			sj = Math.floor(startY/TableCell.size);
			
			ei=  Math.floor(endX/TableCell.size);
			ej = Math.floor(endY/TableCell.size);
			
			
			var length:int = Math.floor(Math.sqrt((ei-si)*(ei-si)+(ej-sj)*(ej-sj)));
			
			if (length == 0) return;
			
			var sign:int;
			var sign2:int;
			
			// Reconstruct the selected word
			
			if (ei-si!=0 ) {
				
				var a:Number = Math.abs(ej-sj)/(ei-si);
				
				sign = (ei-si<0)?-1:1;
				sign2 = (ej-sj<0)?-1:1;
				
				for (i = 0; i<=Math.abs(ei-si); i++) {
					
					j = Math.round(sign*i*a);	
					
					s = s+sp.table[si+sign*i][sj+sign2*j];
				}

			} else {
				
				sign = (ej-sj<0)?-1:1;
				
				for (i = 0; i<=Math.abs(ej-sj); i++) {
					s = s+sp.table[si][sj+sign*i];
				}
				
			}
			
			if (direction<0) {
				var snew:String = "";
				for (i = s.length-1; i>=0; i--) {
					snew = snew + s.charAt(i);
				}
				s = snew;
				
			}
			
			//trace(s);
			// Check if the selected word is a valid solution word.
			
			var placed:int = -1;
			
			for (i = 0; i<sp.tableWordsPlaced.length; i++) {
				if (sp.tableWordsPlaced[i] == s && shownWords[""+i]==null) {
					placed = i;
					break;
				} 
			}
			
			select.graphics.clear();				
			
			// If everything is okay we highlight it as solved word.
			
			if (placed!=-1) {
				solved.graphics.lineStyle(TableCell.size,solvColor,0.60);
				solved.graphics.moveTo(startX,startY);
				solved.graphics.lineTo(endX,endY);
				
				shownWords[""+placed] = true;
				
				_playerSolved++;
				
				succ = this.success.play();
				
				
				
				if (oldSolutionWord != "") endSolutionWord();
				oldSolutionWord = s;
				
				
				if (!sp.learningText[""+s]) {
					sp.menu.markRed(s);
					sp.messageBox.init("No further information for this word.");
				} else {
					sp.messageBox.init(sp.learningText[""+s]);
					sp.menu.markRed(s);
					sp.messageBox.show();
				}
				
				timer.start();

			} else {
				fail = this.failure.play();
			}
				
			
			startX = -1;
			startY = -1;
			
		}
		
		
		private var timer:Timer = new Timer(3000,1);
		private var oldSolutionWord:String = "";
		
		/**
		 * This method is called if the player selected and found a word and the learning text if not relevant (any more)
		 */
		public function endSolutionWord(evt:Event = null):void {

			//
			
			
			if (oldSolutionWord == "") {
				return;	
			}
			
			sp.menu.removeWord(oldSolutionWord);
			oldSolutionWord = "";
			if (sp.wordsPlaced.length <= this._playerSolved+solved.numChildren) {
				
				// Game finished
				
				this.weAreFinished(null);
				
			}

		}
		
		/**
		 * This method is called to show a solution word and highlight it as solved.
		 * @param w The word. 
		 */
		public function showWord(w:String):void {
			
			var placed:int = -1;
			var i:int;
			
			//if (oldSolutionWord != "") sp.menu.removeWord(oldSolutionWord);

			// Is it a solution word ?
			
			for (i = 0; i<sp.tableWordsPlaced.length; i++) {
				if (sp.tableWordsPlaced[i] == w && shownWords[""+i]==null) {
					placed = i;
					break;
				} 
			}
			
			if (placed == -1) return;
			
			// determine start and end coordinated for the highlighting.
			
			var info:Array = sp.wordsPlaceInfo[placed];
			
			var si:int = info[0];
			var sj:int = info[1];
			
			var incx:int = sp.inc_x[info[2]];
			var incy:int = sp.inc_y[info[2]];
			
			var sx:Number = si*TableCell.size+TableCell.size/2;
			var sy:Number = sj*TableCell.size+TableCell.size/2;
			
			for (var k:int = 0; k<w.length-1; k++) {
				si+=incx;
				sj+=incy;
			}
			var ex:Number = si*TableCell.size+TableCell.size/2;
			var ey:Number = sj*TableCell.size+TableCell.size/2;
			
			select.graphics.clear();				
			

			// highlight the word
			
			var layer:Sprite;
			
			if (direction>0) layer = new SolvedLayer(sx,sy,ex,ey,solvColor);
			else layer = new SolvedLayer(ex,ey,sx,sy,solvColor);
							
			if (sp.wordsPlaced.length == this._playerSolved+solved.numChildren+1) {
				
				// Game finished
				
				layer.addEventListener("end",weAreFinished);
				
			}

			solved.addChild(layer);
			
			shownWords[""+placed] = true;


		}
		
		private var ge:SoundChannel;
		
		private function weAreFinished(evt:Event):void {
				
			// Game finished
			
			ge = this.gameEnd.play(0);
			
			this.dispatchEvent(new Event("done"));
			
		}
		
		
		private function mouseMoved(evt:Event):void {
			var _x:Number = this.mouseX;
			var _y:Number = this.mouseY;
			
			var i:int =  Math.floor(_x/TableCell.size);
			var j:int =  Math.floor(_y/TableCell.size);
			
			endX = i*TableCell.size+TableCell.size/2;;
			endY = j*TableCell.size+TableCell.size/2;;
			
			if (i>=sp.puzzleWidth || j>= sp.puzzleHeight) return;
			

			
			if (endX == startX && endY == startY) {
				select.graphics.clear();
				select.graphics.beginFill(0,0.9);
				select.graphics.lineStyle(2,0x000000,0.0);
				select.graphics.moveTo(startX,startY);
				select.graphics.drawCircle(startX,startY,TableCell.size/2);
				select.graphics.endFill();

			} else {
				select.graphics.clear();
				select.graphics.beginFill(0,1);
				select.graphics.lineStyle(TableCell.size,0x000000,0.9);
				select.graphics.moveTo(startX,startY);
				select.graphics.lineTo(endX,endY);
				select.graphics.endFill();
			}
			
			
		}
		
		/**
		 * Coordinates of the start and end points of the current selection.
		 */
		private var startX:Number = -1;
		private var startY:Number = -1;
		private var endX:Number = -1;
		private var endY:Number = -1;
		
		/**
		 * Mouse button down listener.
		 * It starts a selection.
		 */
		private function mouseDown(evt:Event):void {
			
			this._clicks++;
			
			if (oldSolutionWord != "") endSolutionWord(null);

			this.addEventListener(MouseEvent.MOUSE_MOVE, mouseMoved);
			var _x:Number = this.mouseX;
			var _y:Number = this.mouseY;
			
			var i:int =  Math.floor(_x/TableCell.size);
			var j:int =  Math.floor(_y/TableCell.size);
			
			startX = i*TableCell.size+TableCell.size/2;
			startY = j*TableCell.size+TableCell.size/2;
			
			mouseMoved(null);

		}

		/**
		 * With this method we draw the initial grid.
		 */
		private function drawTable():void {
			var cells = new Array();
			var _x:Number = 0;
			var _y:Number = 0;
			for (var i:int = 0; i<sp.puzzleHeight; i++) {
				_x = 0;
				var row:Array = new Array();
				for (var j:int = 0; j<sp.puzzleWidth; j++) {
					row.push(new TableCell(sp.table[j][i]));
					this.addChild(row[j]);
					row[j].x = _x;
					row[j].y = _y;
					_x+=row[j].width;
				}
				_y+=row[0].height;
			}
		}
	}

}