﻿package devarai.games.searchPuzzle.welcome {
	import devarai.common.ui.radiobutton.RadioButtonBasis;
	import devarai.common.ui.radiobutton.RadioButtonGroup;
	
	import devarai.games.searchPuzzle.SearchPuzzle;
	
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	
	import flash.display.MovieClip;
	import flash.events.Event;
	
	/**
	 * This is the welcome dialog window allowing the used to choose the difficulty of the game.
	 */
	public class WelcomeDialog extends MovieClip {
		
		/**
		 * Link to the main class.
		 */
		private var sc:SearchPuzzle;
		
		private var easy:RadioButtonBasis = new RadioButtonBasis("Novato");
		private var adv:RadioButtonBasis = new RadioButtonBasis("Avanzado");
		private var radios:RadioButtonGroup = new RadioButtonGroup();
		
		
		public function WelcomeDialog(_sc:SearchPuzzle) {
			this.sc = _sc;
			this.addEventListener(Event.ADDED_TO_STAGE, showme);
			this.alpha = 0;
			start_mc.addEventListener("interaction", startGame);
			radios.addButton(easy);
			radios.addButton(adv);
			
			this.addChild(easy);
			this.addChild(adv);
			
			easy.x = -40;
			adv.x = -40;
			easy.y = 0;
			adv.y = 20;
		}

		
		/**
		 * Method triggered if play button is hit.
		 */
		private function startGame(evt:Event):void {
			if (tw) tw.stop();
			tw = new Tween(this,"alpha",None.easeIn,this.alpha,0,0.4,true);
			tw.addEventListener("motionFinish", doPlay);
		}

		private function doPlay(evt:Event):void {
			if (easy.activated) sc.difficulty = "beginner";
			else sc.difficulty = "advanced"; 
			sc.doInit();
		}

		
		/**
		 * Tween for fading in.
		 */
		private var tw:Tween = null;
		
		
		/**
		 * Fades in the dialog window
		 */
		private function showme(evt:Event):void {
			if (tw) tw.stop();
			tw = new Tween(this,"alpha",None.easeIn,this.alpha,1,1.0,true);
			
			
		}
	}
	
	
}