﻿package devarai.games.searchPuzzle {
	
	import fl.transitions.Tween;
	import fl.transitions.easing.Elastic;
	import fl.transitions.easing.Regular;
	import fl.transitions.easing.Strong;
	
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.Matrix;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.ui.Mouse;
	import flash.ui.MouseCursor;
	import flash.utils.Timer;
	
	/**
	 * This is the MouseScroll class. It is used in the textfield class to allow scrolling lr.
	 * With it we facilitate scrolling if there is more content than width.
	 */
	public class MouseScroll extends MovieClip {
		
		private var timerDelay = 150;
		private var myTimer : Timer;
		private var waiter : Timer;
		
		private var tween1:Tween;
		private var tween2:Tween;
		private var tween3:Tween;
		
		private var keyPressed:Boolean = false;
		private var _isMouseOver:Boolean = false;
		private var _mouseReleased:Boolean = true;
		
		private var arrow:Sprite = new Sprite();
		private var _active:Boolean = true;
		
		
		private var faderR:Sprite = new Sprite();
		private var faderL:Sprite = new Sprite();

		private var dummy:Sprite = new Sprite();
		
		/**
		 * This is the constructor.
		 */
		public function MouseScroll() {
		
			waiter = new Timer(500,1);
			myTimer = new Timer(timerDelay);
			waiter.addEventListener(TimerEvent.TIMER_COMPLETE,timerActive);
			myTimer.addEventListener(TimerEvent.TIMER, timerFunc);
			
			dummy.addEventListener(MouseEvent.MOUSE_DOWN, _mouseButton); 
			dummy.addEventListener(MouseEvent.MOUSE_UP, _mouseButtonReleased);
			dummy.addEventListener(MouseEvent.MOUSE_OVER, _mouseOnButton);
			dummy.addEventListener(MouseEvent.MOUSE_OUT, _mouseOutofButton);
			
			arrow.graphics.beginFill(0x444444);
			arrow.graphics.lineStyle(2,0,0.05);
			arrow.graphics.moveTo(-5,-10);
			arrow.graphics.lineTo(5,0);
			arrow.graphics.lineTo(-5,10);
			arrow.graphics.lineTo(-5,-10);
			arrow.graphics.endFill();
			
			
			dummy.graphics.beginFill(0,0.01);
			dummy.graphics.drawRect(-5,-10,10,20);
			dummy.graphics.endFill();
		
			
			
			arrow.scaleX = 0.8;
			arrow.scaleY = 0.8;
			
			dummy.scaleX = 0.8;
			dummy.scaleY = 0.8;

			this.addChild(arrow);

			this.addChild(dummy);
			
			arrow.alpha = 0.4;
	
			var matrix:Matrix = new Matrix();

			matrix.createGradientBox(120, 20, 0/180*Math.PI,0,0);
			
			faderL.graphics.beginGradientFill("linear", [0,0],[0,1],[0,255], matrix);				
			faderL.graphics.drawRect(0,0,120,20);
			faderL.graphics.endFill();

			faderR.graphics.beginGradientFill("linear", [0,0],[1,0],[0,255], matrix);				
			faderR.graphics.drawRect(0,0,120,20);
			faderR.graphics.endFill();

			
			
		}
		
		
		/**
		 * @return The display object for fading on the right side of the arrow.
		 */
		public function getFaderR():Sprite { 
			return faderR;
		}
		/**
		 * @return The display object for fading on left side of the arrow.
		 */
		public function getFaderL():Sprite { 
			return faderL;
		}
		
		
		/**
		 * Shows and activates the arrow button.
		 * @param b Boolean value.
		 */
		public function set active(b:Boolean) {
			_active = b;
			if (!b) arrow.visible = false;
			else arrow.visible = true;
		}
		/**
		 * @return <code>true</code> if the arrow button is active.
		 */
		public function get active():Boolean {
			return _active;
		}
		
		
		/**
		 * Initializes the class. Two modes are available. 1. Scolling to the left, 2. Scrolling to the right.
		 * @param tL <code>true</code> if to the left.
		 */
		public function init( tL:Boolean = false) {
			if (tL) { 

				arrow.rotation = 0;

			}
			else {
				
				arrow.rotation = 180;
			}
			
		}
		
		
		private function timerFunc(evt:TimerEvent):void {
			if (keyPressed) passOnKey();
		}
		private function timerActive(evt:TimerEvent):void {
			
			myTimer.start();
		}
		private function passOnKey():void {
			dispatchEvent(new Event("passOnKey"));
		}
		
		private var tween5: Tween;
		private var tween6: Tween;
		
		/**
		 * Arrow button is pressed. Please animate.
		 */
		private function textPressed():void {
			
			passOnKey();
			
			if (tween2) tween2.stop();
			tween2 = new Tween( this, "scaleX", Strong.easeOut,this.scaleX,0.8,0.3,true);
			if (tween3) tween3.stop();
			tween3 = new Tween( this, "scaleY", Strong.easeOut,this.scaleY,0.8,0.3,true);
/*			if (tween5) tween5.stop();
			tween5 = new Tween( arrow, "y", Strong.easeOut,arrow.y,-14,0.3,true);
			if (tween6) tween6.stop();
			tween6 = new Tween( arrow, "x", Strong.easeOut,arrow.x,-10,0.3,true);
			*/
		}
		
		/**
		 * Arrow button is unpressed. Release through animation.
		 */
		private function textUnPressed():void {
			
			if (tween2) tween2.stop();
			tween2 = new Tween( this, "scaleX", Strong.easeOut,this.scaleX,1,0.4,true);
			if (tween3) tween3.stop();
			tween3 = new Tween( this, "scaleY", Strong.easeOut,this.scaleY,1.0,0.4,true);
			if (tween5) tween5.stop();
/*			tween5 = new Tween( arrow_txt, "y", Strong.easeOut,arrow_txt.y,-17.3,0.3,true);
			if (tween6) tween6.stop();
			tween6 = new Tween( arrow_txt, "x", Strong.easeOut,arrow_txt.x,-12.5,0.3,true);
	*/		
			waiter.stop();myTimer.stop();
			
		}
		
		private function _mouseButton(evt:MouseEvent):void {
			if (!keyPressed) {
				textPressed();
				keyPressed = true;
				waiter.start()
			}
			_mouseReleased = false;
		}
		
		private function _mouseButtonReleased(evt:MouseEvent):void {
			if (keyPressed) {
				textUnPressed();
				keyPressed = false;
			}
			_mouseReleased = true;
		}
		
		private var oldCursor:String;
		
		private function _mouseOnButton(evt:MouseEvent):void {
			if (!keyPressed && !_isMouseOver) {
				if (tween1) tween1.stop();
				tween1 = new Tween(arrow,"alpha",Regular.easeIn, arrow.alpha,1,0.4,true);
				_isMouseOver = true;
				oldCursor = Mouse.cursor;
				Mouse.cursor = MouseCursor.BUTTON;
			}
		}
		private function _mouseOutofButton(evt:MouseEvent):void {
			if (keyPressed && !_mouseReleased) {
				textUnPressed();
				_mouseReleased = true;
				keyPressed = false;
			}
			
			if (tween1) tween1.stop();
			tween1 = new Tween(arrow,"alpha",Regular.easeIn, arrow.alpha,0.4,0.4,true);
			Mouse.cursor = oldCursor;
			_isMouseOver = false;
			
		}
	}
}