package devarai.games.searchPuzzle {
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * This class is used to highlight a solution word through an animation.
	 */
	public class SolvedLayer extends Sprite {
	
		// animation tween
		private var tw:Tween = null;
		
		/**
		 * @private
		 */
		public var temp:Number;		
		
		/**
		 * start and end coordinates for the highlighting.
		 */
		private var _sx,_sy:Number;
		private var _ty,_tx:Number;
		/**
		 * COlor of the highlighting.
		 */
		private var _col:int;
		
		/**
		 * Constructor.
		 */
		public function SolvedLayer(sx:Number,sy:Number,tx:Number,ty:Number,col:int) {
			
			_sx = sx; _sy = sy;
			_tx = tx; _ty = ty;
			_col = col;
			
			this.addEventListener(Event.ADDED_TO_STAGE, start);
		}
		
		/**
		 * Start the animation when added to the stage.
		 */
		private function start(evt:Event):void {
			var distance:Number = Math.sqrt((_sx-_tx)*(_sx-_tx)+(_sy-_ty)*(_sy-_ty));
			
			tw = new Tween(this,"temp",None.easeIn,0,1,distance/(TableCell.size*4.7),true);
			tw.addEventListener("motionChange", change);
			tw.addEventListener("motionFinish", finish);

		}
		
		/**
		 * Draw a thick line from start to end point part by part.
		 */
		private function change(evt:Event):void {
			this.graphics.clear();
			this.graphics.lineStyle(TableCell.size,_col,0.60);
			this.graphics.moveTo(_sx,_sy);
			
			var ex:Number = _sx+temp*(_tx-_sx)
			var ey:Number = _sy+temp*(_ty-_sy)
			
			this.graphics.lineTo(ex,ey);
		}
		
		/**
		 * The solution is completely visible now.
		 */
		private function finish(evt:Event):void {
			this.dispatchEvent(new Event("end"));
		}
		
		
		
		
	}
	
}