﻿package devarai.games.searchPuzzle.menu {
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	/**
	 * This class is used for handling the game mode and whether we see the bulb or the watch or both.
	 */
	public class BulbWatchHandler extends MovieClip {
		
		
		private var _watch:StopWatchWrapper = new StopWatchWrapper();
		private var _bulb:Bulb = new Bulb();
		private var _cancel:CrossButton;
		private var _switcher:Switcher;
		
		private var bulbActive:Boolean = true;
		
		public function BulbWatchHandler(isExam:Boolean = false) {
			
			this.addChild(_watch);
			this.addChild(_bulb);
			
			_watch.y = -2;
			_watch.x = 8;
			
			if (isExam) {
				_bulb.visible = false;
				_cancel = new CrossButton();
				this.addChild(_cancel);
				_cancel.y = 11;
				_cancel.x  = 27;
				_cancel.addEventListener(MouseEvent.MOUSE_OVER, showCancelHint);
				_cancel.addEventListener(MouseEvent.MOUSE_OUT, hideCancelHint);
				_cancel.addEventListener("interaction",done);
				
				
			} else {
				_watch.visible = false;	
				_switcher = new Switcher();
				this.addChild(_switcher);
				_switcher.y = 11;
				_switcher.x  = 12;
				_switcher.addEventListener(MouseEvent.CLICK, switchDisplay);
			}
			
		} 
		
		private function done(evt:Event):void {
			this.dispatchEvent(new Event("cancelled"));
		}
		
		/**
		 * Tweens for switching the display
		 */
		private var swTw:Tween = null;
		private var swTw2:Tween = null;
		private var swTw3:Tween = null;
		
		private function switchDisplay(evt:Event):void {
			if (swTw) swTw.stop();
			if (swTw2) swTw2.stop();
			if (swTw3) swTw3.stop();
			if (bulbActive) {
				swTw = new Tween(_bulb,"alpha",None.easeIn,_bulb.alpha,0,0.2,true);
				swTw.addEventListener("motionFinish",setInvisBulb);
				_watch.visible = true;
				swTw2 = new Tween(_watch,"alpha",None.easeIn,_watch.alpha,1,0.2,true);
				bulbActive = false;
				_switcher.alpha = 0;
				_switcher.x  = 26;
			} else {
				swTw = new Tween(_watch,"alpha",None.easeIn,_watch.alpha,0,0.2,true);
				swTw.addEventListener("motionFinish",setInvisWatch);
				_bulb.visible = true;
				swTw2 = new Tween(_bulb,"alpha",None.easeIn,_bulb.alpha,1,0.2,true);
				bulbActive = true;
				_switcher.alpha = 0;
				
			}
		}
		
		private function showSwitcher():void {
			if (swTw3) swTw3.stop();
			swTw3 = new Tween(_switcher,"alpha",None.easeIn,_switcher.alpha,1,0.6,true);
		}
		
		private function setInvisBulb(evt:Event):void {
			showSwitcher();
			_bulb.visible = false;
		}
		private function setInvisWatch(evt:Event):void {
			showSwitcher();
			_watch.visible = false;
			_switcher.x  = 12;
		}
		
		/**
		 * Show / Hide the tooltip message if someone is over the cancel cross. 
		 */
		private function showCancelHint(evt:Event):void {
			_watch.message = "End Game";
		}
		private function hideCancelHint(evt:Event):void {
			_watch.message = "";
		}
		
		
		/**
		 * @return The stop watch wrapper
		 */
		public function get watch():StopWatchWrapper {
			return this._watch;
		}
		
		/**
		 * @return The light bulb object
		 */
		public function get bulb():Bulb {
			return this._bulb;
		}
		
		
	}
	
	
}