﻿package devarai.games.searchPuzzle.menu {
	import devarai.common.ui.scrollbars.HorizontalScrollbar;
	import devarai.common.ui.scrollbars.IScrollBar;
	import devarai.common.ui.scrollbars.IScrollBarH;
	import devarai.common.ui.scrollbars.VerticalScrollbar;
	import devarai.games.searchPuzzle.SearchPuzzle;
	import devarai.games.searchPuzzle.menu.MenuRow;
	
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BevelFilter;
	import flash.filters.DropShadowFilter;
	import flash.filters.GlowFilter;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	/**
	 * This is the menu class that represents the menu on the right side of the component.
	 * It shows the remaining solution words, lets you select some which can be solved automatically
	 * by clicking on the light bulb.
	 */
	public class Menu extends MovieClip implements IScrollBar, IScrollBarH {
		
		/**
		 * Background sprite for the menu
		 */
		private var background:Sprite = new Sprite();
		// Menu mask
		private var maske:Sprite = new Sprite();
		// All the entries of the menu
		private var rows:Vector.<MenuRow> = new Vector.<MenuRow>();
		// Wraps arround the rows and takes the mask
		private var rowsWrapper:Sprite = new Sprite();
		
		/**
		 * The light bulb  and stopwatch object
		 */
		private var bulbwatch:BulbWatchHandler;
		/**
		 * This is the minimum width of a menu row according to the max content width of the bigges row.
		 */
		private var maxTextWidth:Number = 0;
		
		/**
		 * Maximum possible width of a row
		 */
		private var maxWidth = 355;
		/**
		 * The width of the menu.
		 */
		public static var myWidth:Number = 139;
		/**
		 * The height of the menu.
		 */
		private var myHeight:Number  = 0;
		/**
		 * A reference to the main class.
		 */
		private var sc:SearchPuzzle;
		/**
		 * The scrollbars.
		 */
		private var scrollbarV:VerticalScrollbar;
		private var scrollbarH:HorizontalScrollbar;
		
		/**
		 * @inheritDoc
		 */
		override public function get width():Number {
			return myWidth+4;
		}
		
		
		/**
		 * This method highlights the cell for a special word.
		 */
		public function markRed(w:String):void {
			var i:int;
			for (i  = 0; i<rows.length; i++) {
				if (rows[i].tableContent == w) {
					rows[i].redMarker = true;
					
					this.scrollPosV = Math.max(0,rows[i].y-this.maske.height/2);
					this.dispatchEvent(new Event("cursorUpdate"));
					break;
				}
			}			
		}
		
		
		private var alphaTweens:Vector.<Tween> = new Vector.<Tween>();
		/**
		 * This method removes a word out of the menu.
		 * @param w The word to be removed.
		 */
		public function removeWord(w:String):void {
			var i:int;
			for (i  = 0; i<rows.length; i++) {
				if (rows[i].tableContent == w) {
					
					alphaTweens.push(new Tween(rows[i],"alpha",None.easeIn,rows[i].alpha,0,0.33,true));
					alphaTweens[alphaTweens.length-1].addEventListener("motionFinish", removeWordFinal);						
					break;
				}
			}			
		}
		
		/**
		 * If a row was deleted and faded out completely this method removed it finally.
		 */
		private function removeWordFinal(evt:Event):void {
			
			var i:int;
			for (i  = 0; i<rows.length; i++) {
				if (rows[i].alpha == 0) {
					rowsWrapper.removeChild(rows[i]);
					rows.splice(i,1);
					i--;
				}
			}
			
			

		}
		/**
		 * This method animated the menu list. Especially if a row was deleted.
		 */
		private function squeezer(evt:Event):void {
			var anY:Number = 0;
			var amaxTextWidth = 0;
			
			var animated:Boolean = false;
			var i:int;
			
			for (i = 0; i<rows.length; i++) {
				if (rows[i].y > anY) {
					rows[i].y = (rows[i].y+anY)/2;
					animated = true;
				}
				anY+=rows[i].height;
				
				amaxTextWidth = Math.max(rows[i].maxTextWidth,amaxTextWidth);
			}
			
			
			if (amaxTextWidth!=this.maxTextWidth || animated) {
				this.maxTextWidth = amaxTextWidth;	
				this.dispatchEvent(new Event("cursorUpdate"));
			}

		}
		
		
		
		/**
		 * Removes all words out of the menu which menu entries are activated/selected.
		 */
		private function removeActivatedWords():void {
			var i:int;
			for (i  = 0; i<rows.length; i++) {
				if (rows[i].activated) {
					
					alphaTweens.push(new Tween(rows[i],"alpha",None.easeIn,rows[i].alpha,0,0.33,true));
					alphaTweens[alphaTweens.length-1].addEventListener("motionFinish", removeWordFinal);						
					
				}
			}			

			
		}
		
		/**
		 * Empties thwe whole menu.
		 */
		public function clear():void {
			var i:int;
			for (i  = 0; i<rows.length; i++) {
				rowsWrapper.removeChild(rows[i]);
				rows.splice(i,1);
				i--;
			}
			var anY:Number = 0;
			this.maxTextWidth = 0;
			alphaTweens = new Vector.<Tween>();
			this.dispatchEvent(new Event("cursorUpdate"));			
		}
		
		/**
		 * Adds a words to the menu on the bottom.
		 * @param w The word to be added.
		 */
		public function addWord(w:String, tableW:String):void {
			
			if (sc.specialClue[""+tableW]!=null) {
				rows.push(new MenuRow(this.maxWidth, sc.specialClue[""+tableW],tableW));
			} else {
				rows.push(new MenuRow(this.maxWidth, w,tableW));	
			}
			
			rowsWrapper.addChild(rows[rows.length-1]);
			var anY:Number = 0;
			if (rows.length>1) {
				anY =rows[rows.length-2].y+rows[rows.length-2].height;
			}
			rows[rows.length-1].y = anY;		
			
			this.maxTextWidth = Math.max(rows[rows.length-1].maxTextWidth,this.maxTextWidth);
			this.dispatchEvent(new Event("cursorUpdate"));
		}
		
		/**
		 * Constructor.
		 * @param _sc A reference to the main class.
		 * @param _height The desired height of the menu
		 */
		public function Menu(_sc:SearchPuzzle,_height:Number) {
			
			
			sc = _sc;
			this.myHeight = _height;
			
			var i,j:int;
			
			// Create the background
			
			background.graphics.beginFill(0xf1f1f1,0.9);
			background.graphics.lineStyle(2,0x333333,0.1);
			background.graphics.drawRect(0,0,myWidth,_height-35	);			
			background.graphics.endFill();
			
			background.filters = [new DropShadowFilter(0,120,0x000000,0.25,7,7,1.5,3,true),new BevelFilter(2,230,0xffffff,0.9,0,0.1,2,2,2,3)];
			
			// Create the mask
			
			this.maske.graphics.beginFill(0);
			this.maske.graphics.drawRect(0,0,myWidth-3,_height-39);
			this.maske.graphics.endFill();
			
			// Add things...
			
			this.addChild(maske);
			rowsWrapper.mask = maske;
			
			this.addChild(background);
			
			this.addChild(rowsWrapper);
			
			rowsWrapper.cacheAsBitmap = true;
			this.cacheAsBitmap = true;
			
			rowsWrapper.x = 2;
			rowsWrapper.y = 1;
			
			maske.x = 1;
			maske.y = 1;
			
			
			// Set up the scroll bars
			
			scrollbarV = new VerticalScrollbar(this,_height-41);
			this.addChild(scrollbarV);
			scrollbarV.x = myWidth-14;
			scrollbarV.y = 5;
			
			
			scrollbarV.addEventListener("showScrollbar", showVScrollbar);
			scrollbarV.addEventListener("hideScrollbar", hideVScrollbar);
			
			scrollbarH = new HorizontalScrollbar(this,myWidth-6);
			
			this.addChild(scrollbarH);
			scrollbarH.y = _height-49;
			scrollbarH.x = 3;
			
			
			scrollbarH.addEventListener("showScrollbar", showHScrollbar);
			scrollbarH.addEventListener("hideScrollbar", hideHScrollbar);
			

			// Configure the light bulb
			
			bulbwatch = new BulbWatchHandler(sc.isExam);
			
			bulbwatch.y = _height-30;
			bulbwatch.x = 15;
			bulbwatch.watch.addEventListener("countDownEnd", weAreFinished);			
			bulbwatch.bulb.addEventListener(MouseEvent.CLICK, bulbClick);
			this.addChild(bulbwatch);

			bulbwatch.addEventListener("cancelled",weAreFinished);
						
			this.dispatchEvent(new Event("cursorUpdate"));
			
			this.addEventListener(Event.ENTER_FRAME, squeezer);
			
		}
		
		/**
		 * This method is called if we have a countdown or something that forces us to finish the game.
		 */
		private function weAreFinished(evt:Event):void {
			this.dispatchEvent(new Event("done"));
		}
		
		/**
		 * @return The time stopwatch wrapper.
		 */
		public function get timer():StopWatchWrapper {
			return bulbwatch.watch;
		}
		
		/**
		 * This method is triggered if a horizontal scrollbar is needed.
		 */
		private function showHScrollbar(evt:Event):void {
			maske.height = myHeight-39-12;
			scrollbarV.height = myHeight-41-14;
			this.dispatchEvent(new Event("cursorUpdateV"));
		}
		/**
		 * This method is called if a horizontal scrollbar is not needed any more. 
		 */
		private function hideHScrollbar(evt:Event):void {
			maske.height = myHeight-39;
			scrollbarV.height = myHeight-41;
			this.dispatchEvent(new Event("cursorUpdateV"));
		}
		/**
		 * Vertical scrollbar needed.
		 */
		private function showVScrollbar(evt:Event):void {
			maske.width = myWidth-6-10;
			this.dispatchEvent(new Event("cursorUpdateH"));
		}
		/**
		 * Vertical scrollbar can disappear.
		 */
		private function hideVScrollbar(evt:Event):void {
			maske.width = myWidth-3;
			this.dispatchEvent(new Event("cursorUpdateH"));
		}
		
		/**
		 * Someone clicked on the light bulb. So show the selected solution words...
		 */
		private function bulbClick(evt:Event):void {
			for (var i:int = 0; i<this.rows.length; i++) {
				if (rows[i].activated) {
					sc.searchTable.showWord(rows[i].tableContent);
					
				}
			}
			this.removeActivatedWords();					
			
		}
		
		/**
		 * Someone clicks on a row.
		 */
		private function rowClicked(evt:Event):void {
			var i:int;
			for ( i = 0; i<this.rows.length; i++) {
				if (evt.currentTarget == rows[i]) break;				
			}
			this.dispatchEvent(new	PuzzleMenuEvent(PuzzleMenuEvent.NEW_SELECT,rows[i].content));
		}
		
		/**
		 * Scrolling tweens
		 */
		private var tw:Tween = null;
		private var twh:Tween = null;
		
		/**
		 * @private
		 */
		public var newScrollPos:Number = 0;
		public var newScrollPosH:Number = 0;
		
		/**
		 * This method is relevant if we have more rows than height. So we have to scroll.
		 */
		
		/**
		 * This gives you the a vertical scroll position
		 * @return position
		 */		
		public function get scrollPosV():Number {
			return newScrollPos;
		};
		/**
		 * This sets a vertical scroll position
		 * @param n Position (>=0 and <=maxScrollPosV())
		 * @see IScrollBar#maxScrollPosV()
		 */
		public function set scrollPosV(n:Number):void {
			
			if (tw) tw.stop();
			newScrollPos = Math.max(0,Math.min(n,rowsWrapper.height-this.maske.height));
			tw = new Tween(rowsWrapper,"y",None.easeIn, rowsWrapper.y,-newScrollPos+1,0.2,true);
			
		}
		/**		
		 * Gives you the maximum possible scroll position.
		 * @return Max. scroll position.
		 */
		public function get maxScrollPosV():Number {
			return Math.max(rowsWrapper.height-this.maske.height,0);
		}
		
		/**
		 * Scrolling page height in pixels.
		 */
		public function get pageHeight():Number {
			return this.maske.height;
		}
		
		/**
		 * @return The horizontal scrolling position.
		 */
		public function get scrollPosH():Number {
			return newScrollPosH;
		}
		/**
		 * Sets the horizontal scrolling position.
		 * @param n Position. >=0 and <= maxScrollPosH
		 * @see IScrollBarH#maxScrollPosH()
		 */
		public function set scrollPosH(n:Number):void {
			{
				if (twh) twh.stop();
				var t:Number = Math.min(n,maxTextWidth-this.maske.width);
				var diff:Number = Math.min(this.maske.width-maxTextWidth,0); 
				newScrollPosH = Math.max(0,t);
				twh = new Tween(rowsWrapper,"x",None.easeIn, rowsWrapper.x,2-diff-newScrollPosH+this.maske.width-this.maxWidth,0.2,true);
			} 
			
		}
		
		/**
		 * This method gives us the maximum horizontal scrolling position.
		 * @return maximum.
		 */
		public function get maxScrollPosH():Number {
			return Math.max(0,maxTextWidth-this.maske.width);
		}
		/**
		 * Scrolling page width in pixels.
		 */
		public function get pageWidth():Number {
			return this.maske.width;
			
		}
		
	}
	
	
}