﻿package devarai.games.searchPuzzle.menu {
	import devarai.games.searchPuzzle.menu.StopWatch;
	
	import flash.display.MovieClip;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;

	/**
	 * This is the timer handler useful for handling the exam mode of the search puzzle.
	 */
	public class StopWatchWrapper extends MovieClip {
		
		private var time_txt:TextField = new TextField();
		private var format:TextFormat = new TextFormat("Arial",15,0x000000,null,null,null,null,null,"left");
		private var stopWatch:StopWatch = new StopWatch();
		private var timer:Timer;
		private var _time:Number;
		private var _countDownTime:Number = 0;
		
		/**
		 * Constructor.
		 */
		public function StopWatchWrapper() {
			time_txt.embedFonts = true;
			time_txt.selectable = false;
			time_txt.mouseEnabled = false;
			this.addChild(stopWatch);
			this.addChild(time_txt);
			time_txt.x = stopWatch.width-2;
			timer = new Timer(1000,0);
		
			
		}	
		
		private var _message:String = "";
		
		/**
		 * Replaces eventually the time with a short message
		 */
		public function set message(s:String):void {
			_message = s;
			this.outputTime();
		}
		
		/**
		 * This function is called if we have a countdown and it is finished.
		 * 
		 */
		private function countDownFinished(evt:Event):void {
			this.dispatchEvent(new Event("countDownEnd"));
		}
		
		/**
		 * 
		 * Start the exam timer. If the time is limited / a countdown is desired you have to set the limit in seconds.
		 * @param countDown Limit of a countdown in seconds. "0" if no countdown.
		 */
		public function startTimer(countDown:Number = 0):void {
			if (countDown==0) {
				_time = 0;
				timer.addEventListener(TimerEvent.TIMER, regularFct);
				this._countDownTime = 0;
			} else {
				_time = countDown;
				this._countDownTime = countDown;
				timer.addEventListener(TimerEvent.TIMER, countDownFct);
				stopWatch.start(countDown);
			}
			timer.start();
			outputTime();
		}
		
		/**
		 * Stops the timer.
		 */
		public function stopTimer():void {
			timer.stop();
			stopWatch.pause();
		}
		
		private function regularFct(evt:Event):void {
			_time+= 1;
			outputTime();
			
		}
		
		private function countDownFct(evt:Event):void {
			_time-=1;
			outputTime();
			if (_time<=0) {
				timer.stop();	
				this.countDownFinished(null);
			}
		}
		
		/**
		 * Gives you the time the user tries to solve the puzzle so far. 
		 * 
		 */
		public function get time():Number {
			if (this._countDownTime>0) {
				return this._countDownTime-_time;
			} else {
				return _time;
			}
		}
		
		/**
		 * Outputs the present user time 
		 */
		private function outputTime():void {
			
			if (this._message != "") {
				time_txt.text = this._message;
			} else {
				var mins:int = int(_time/60);
				var secs:int = int(_time%60);
				
				
				var minString:String = ""+mins;
				if (mins<10) minString = "0"+minString;
				var secString:String = ""+secs;
				if (secs<10) secString = "0"+secString;
				
				time_txt.text = minString+":"+secString+ " min";
			}
			
			time_txt.setTextFormat(format);

		}
		
	}
	
	
}