﻿package devarai.common.music {
	
	
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.display.MovieClip;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.media.Sound;
	import flash.media.SoundChannel;
	import flash.media.SoundLoaderContext;
	import flash.media.SoundMixer;
	import flash.media.SoundTransform;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import flash.utils.ByteArray;
	
	public class SmallPlayer extends MovieClip {
		
		private var mySound:Sound = new Sound();
		private var myChannel:SoundChannel = new SoundChannel();
		private var bytes:ByteArray = new ByteArray();
		private var array:Array;
		
		private const plot_hoehe:int=20;
		private const anzahl_kanal:int=00;
		
		
		private var playList:Array =  null;
		private var mySounds:Array;
		
		public function SmallPlayer() {
			
			Security.allowDomain("*");
			
			pause_mc.addEventListener(MouseEvent.CLICK, pausme);
			play_mc.addEventListener(MouseEvent.CLICK, playme);
			forw_mc.addEventListener(MouseEvent.CLICK, nextsong);
			back_mc.addEventListener(MouseEvent.CLICK, prevsong);
						
			pause_mc.addEventListener(MouseEvent.MOUSE_OVER, fadein);
			pause_mc.addEventListener(MouseEvent.MOUSE_OUT, fadeOut);
			pause_mc.buttonMode = true;
			pause_mc.focusRect = false;
			pause_mc.alpha =  0.3;
			
			play_mc.addEventListener(MouseEvent.MOUSE_OVER, fadein);
			play_mc.addEventListener(MouseEvent.MOUSE_OUT, fadeOut);
			play_mc.buttonMode = true;
			play_mc.focusRect = false;
			play_mc.alpha =  0.3;
			
			forw_mc.alpha = 0.3;
			forw_mc.focusRect = false;
			forw_mc.buttonMode = true;
			forw_mc.addEventListener(MouseEvent.MOUSE_OVER, fadein);
			forw_mc.addEventListener(MouseEvent.MOUSE_OUT, fadeOut);
			
			back_mc.alpha = 0.3;
			back_mc.focusRect = false;
			back_mc.buttonMode = true;
			back_mc.addEventListener(MouseEvent.MOUSE_OVER, fadein);
			back_mc.addEventListener(MouseEvent.MOUSE_OUT, fadeOut);

			this.addEventListener(Event.ENTER_FRAME, myFrame);

			//this.addChild(this._bars);
			//this._bars.x = 0;
			//this._bars.y = -0;

			
			//this._bars.mask = drawScanLines( );

			
		}
		
		/**
		 * Plays the next song in our playlist.
		 */
		private function nextsong(evt:Event) {
			this.stopChannel();
			oldPos = 0;
			songNr++;
			loadAndPlay(songNr);
		}
		/**
		 * Palys the previous song in our playlist.
		 */
		private function prevsong(evt:Event) {
			this.stopChannel();
			oldPos=0;
			songNr--;
			if (songNr<0) songNr = playList.length-1;
			loadAndPlay(songNr);
		}
		
		private var oldPos:int =0;
		private var stoped:Boolean = false;
		
		/**
		 * Starts playing a song.
		 */
		public function playme(evt:Event) {
			if (myChannel) {
				this.stopChannel();
				if (stoped) myChannel = mySound.play(oldPos);
				else myChannel = mySound.play(0);
				myChannel.soundTransform  = new SoundTransform(volume);
				myChannel.addEventListener("soundComplete",nextsong);
				stoped = false;
				pause_mc.alpha = 0.3;
				play_mc.alpha = 0.8;
			}
			
		}
		
		private var oldChannel:SoundChannel;
		private var oldSoundTransform:SoundTransform;
		
		private function stopChannel():void {
			
			if (oldChannel) {
				oldChannel.stop();
			}
			
			oldChannel = myChannel;
			oldSoundTransform = oldChannel.soundTransform;
			
			oldChannel.soundTransform = this.oldSoundTransform;
		}
		
		/**
		 * Pauses the song.
		 */
		private function pausme(evt:Event) {
			if (myChannel && !stoped) {
				oldPos = myChannel.position;
				this.stopChannel(); 
				stoped = true;
				play_mc.alpha = 0.3;
			}
		}
		private function fadein(evt:Event):void {
			(evt.currentTarget as MovieClip).alpha = 0.8;
		}
		private function fadeOut(evt:Event):void {
			
			if (stoped && evt.currentTarget == pause_mc) return;
			if (!stoped && evt.currentTarget == play_mc) return;
						
			(evt.currentTarget as MovieClip).alpha = 0.3;
		}
		
		
		
		
		private function loadAndPlay(nr:int):void {
			
			if (nr>=playList.length) nr = 0;
			if (playList.length==0) return;
			
			if (mySounds[nr]==null) {
				mySound = new Sound();
			
				var req = new URLRequest(playList[nr]);
				var context:SoundLoaderContext = new SoundLoaderContext(1500,true);
				mySound.load(req,context);
				mySounds[nr] = mySound;
			} else {
				mySound = mySounds[nr];
			}
			
			songNr = nr;
			if (!stoped){		
				if (myChannel) this.stopChannel();
				myChannel=mySound.play(0,0);
				myChannel.soundTransform  = new SoundTransform(volume);
				myChannel.addEventListener("soundComplete",nextsong);
				play_mc.alpha = 0.8;
			}
		}
		
		private var songNr:int = 0;

		
		private var volume:Number;
		
		
		/**
		 * Sets up the music player with a playlist.
		 */
		public function init(playListe:Array, firstSong = 0, autoPlay:Boolean= false, _volume:Number  = 0.3) {
			
			this.volume = _volume;
			
			this.stopChannel();
			
			if (playListe == null) return;
			if (playListe.length==0) return;
			
			oldPos = 0;
			stoped = !autoPlay;
			myChannel = new SoundChannel();
			songNr++;
			if (playList == null) {  // erster Aufruf
				
				playList = playListe;				
				mySounds = new Array();
				for (var i = 0; i<playList.length; i++) mySounds.push(null);
				songNr  = firstSong;
				
			}
			
			if (playListe.length == 1) {
				forw_mc.visible = false;
				back_mc.visible = false;
				this._bars.x = 40;
			} else {
				this._bars.x = 0;
				forw_mc.visible = true;
				back_mc.visible = true;

			}
			
			
			loadAndPlay(songNr);
			
		}
		
		private function myFrame(event:Event):void {

			if (this.oldChannel && this.oldSoundTransform) {
				
				this.oldSoundTransform.volume-=0.05;
				this.oldChannel.soundTransform = this.oldSoundTransform;
				
				if (this.oldSoundTransform.volume <=0) {
					this.oldChannel.stop();
					this.oldChannel = null;
					
				}
				
				
			}
			
			//updates();
			
			
		}
		
		private var _bars:Sprite = new Sprite();

		private function drawScanLines():Shape {

			var noOfLines:int = 10;
			var line:Shape = new Shape( );
			var runningY:int = 0;
			for(var i:int = 0; i < noOfLines ; ++i) {
				line.graphics.lineStyle( 1, 0x000000, 1 );
				line.graphics.moveTo( 0, runningY );
				line.graphics.lineTo( 32, runningY );
				addChild( line );
				runningY += 2;
			}
			return line;
		}
		
		private function updates():void {
			var spectrumData:ByteArray = new ByteArray( );
			try {
				SoundMixer.computeSpectrum(spectrumData, true, 2);
			}
			catch(e:Error) {
				spectrumData = new ByteArray();
				for(var j : uint = 0;j < 2048; j++) {
					spectrumData.position = j;
					spectrumData.writeFloat(myRandom(-0.5, 0.5));
				}
				spectrumData.position = 0;
			}
			_bars.graphics.clear( );
			_bars.graphics.beginFill( 0x00000,0.6 );
			for (var i:Number = 0; i < 8 ; i += 1) {
				var sum:Number = 0;
				for (var k:int = 0; k<16; k++) {
					var n:Number = (	spectrumData.readFloat( )) * 12;
					sum+= n;	
					
				} 
				sum = sum/2;
				if (sum>20) sum = 20;
				_bars.graphics.drawRect( i*5, 20, 4, -sum );
			}
		}

		private function myRandom(...args) : Number {
			var argLength : uint = args.length;
			switch(argLength) {
				case 0:
					return Math.random();
					break;
				case 2: // returns a random float between args[0] and args[1];
				case 3:
					var returnValue : Number = (Math.random() * (Number(args[1]) - Number(args[0]))) + Number(args[0]);
					return (args[2] != undefined && Boolean(args[2])) ? int(returnValue) : returnValue;
					break;
				default:
					
					return undefined;
					break;
			}
		}
		private function onPlaybackComplete(event:Event) {
			//			removeEventListener(Event.ENTER_FRAME, myFrame);
			//			removeEventListener(Event.ENTER_FRAME, zeigeSpectrum);
		}
		
		
		
	}
	
	
}
	
	
	
	
	
