﻿package devarai.games.searchPuzzle {
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	/**
	 * This class displays a text message on the bottom if the player found a word. (in reinforcment learning mode)
	 */
	public class LearningText extends Sprite {
		
		private var tf:LearningTextField;
		private var tf2:LearningTextField;
		private var background:Sprite = new Sprite();
		
		/**
		 * Says if tf (1) or tf2 (2) is displayed.
		 */
		private var activeTF:int = 1;
		
		/**
		 * Width of the message box.
		 */
		private var myWidth:Number;
		/**
		 * Link to the main class
		 */
		private var _sp:SearchPuzzle;
		
		override public function get height():Number {
			if (_sp.isLearningText) return 32;
			else return 0;
		}

		private function drawBackground(hei:Number):void {
			background.graphics.clear();
			background.graphics.beginFill(0x444444,0.14);
			background.graphics.drawRect(10,0,myWidth-5,2);
			background.graphics.endFill();
			background.graphics.beginFill(0xffffff,1);
			background.graphics.drawRect(10,2,myWidth-5,1.2);
			background.graphics.endFill();

		}
		/**
		 * Constructor.
		 * @param width The width of the message box.
		 * @param sp Mein class.
		 */
		public function LearningText(width:Number, sp:SearchPuzzle) {
			tf = new LearningTextField(width);
			tf2 = new LearningTextField(width);
			this.myWidth = width;
			this.tf.x = 7;
			this.tf.y = 5;
			this.addChild(tf);
			this.tf2.x = 7;
			this.tf2.y = 5;
			this.addChild(tf2);
			tf2.alpha = 0;
			tf2.visible = false;
			this.addChild(background);
			this._sp = sp;
			this.tf.text = "Please try to solve the puzzle above.";
			this.y = _sp.height - 30;
			drawBackground(tf.height+6);
		}
		
		private var tw1:Tween = null;
		private var tw2:Tween = null;
		
		/**
		 * This method configures the message box.
		 * @param text The message.
		 */
		public function init(text:String):void {
						
			if (this.activeTF == 2) {
				tf.text = text;
				this.activeTF = 1;
				tf.visible = true;
				
				if (tw1) tw1.stop();
				tw1 = new Tween(tf,"alpha",None.easeIn,tf.alpha,1,0.3,true);
				if (tw2) tw2.stop();
				tw2 = new Tween(tf2,"alpha",None.easeIn,tf2.alpha,0,0.3,true);
				tw2.addEventListener("motionFinish", tf2Invis);
				
			} else {
				tf2.text = text;
				this.activeTF = 2;
				tf2.visible = true;
				
				if (tw1) tw1.stop();
				tw1 = new Tween(tf,"alpha",None.easeIn,tf.alpha,0,0.3,true);
				tw1.addEventListener("motionFinish", tfInvis);
				if (tw2) tw2.stop();
				tw2 = new Tween(tf2,"alpha",None.easeIn,tf2.alpha,1,0.3,true);

			}
		}
		
		private function tf2Invis(evt:Event):void {
			tf2.visible = false;
			tf2.text = "";
		}
		private function tfInvis(evt:Event):void {
			tf.visible = false;
			tf.text = "";
		}
		
		private var tw:Tween = null;
		/**
		 * Fades in the message.
		 */
		public function show():void {
			if (tw) tw.stop();
//			this.visible = true;
			tw = new Tween(this,"alpha",None.easeIn,this.alpha,1,0.45,true);
		}
		/**
		 * Fades out the message and sets it finally invisible.
		 */
		public function hide():void {
			if (!this.visible) return;
			if (tw) tw.stop();
			tw = new Tween(this,"alpha",None.easeIn,this.alpha,0,0.45,true);
//			tw.addEventListener("motionFinish", invis);
		}
		
		private function invis(evt:Event):void {
			this.visible = false;
		}
		
	}
	
	
	
}