﻿package devarai.games.searchPuzzle.menu {
	import fl.transitions.Tween;
	import fl.transitions.easing.None;
	
	import flash.display.BlendMode;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Rectangle;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	/**
	 * This is a row/element of the menu class.
	 * @see Menu
	 */
	public class MenuRow extends MovieClip {
		
		private var select:MovieClip;
		private var unselect:MovieClip;
		
		private var marker:MovieClip;
		
		private var tfSel:Sprite;
		private var tfUnsel:Sprite;
		
		private var _activated:Boolean = false;
		
		private var _maxTextWidth:Number;
		
		private var myText:String;
		private var myTableText:String;
		
		/**
		 * @return The content of this row
		 */
		public function get content():String {
			return myText;
		}
		
		public function get tableContent():String {
			return this.myTableText;
		}
		
		/**
		 * @return The width of the content in pixels.
		 */
		public function get maxTextWidth():Number {
			return this._maxTextWidth;
		} 
		/**
		 * This method is meant to replace the Adobe standard textfield component which is buggy
		 * with respect to right-to-left languages.
		 */
		private function createTextSprite(text:String, color :int = 0xffffff):Sprite {
			
			var temp:Sprite = new Sprite();
			var tfo:TextFormat = new TextFormat("_sans",14,color,null,null,null,null,null,"left");
			
			var _x:Number = 0;
			for (var i:int = 0; i<text.length; i++) {
				var tf:TextField = new TextField();
				
				tf.height = 23;
				tf.text = text.charAt(i);
				tf.setTextFormat(tfo);
				var rect:Rectangle = tf.getCharBoundaries(0);
				tf.width = rect.x+rect.width+2;
				temp.addChild(tf);
				tf.x = _x;
				_x+=tf.width-rect.x-2;
			}
			return temp;
		}
		
		/**
		 * Constructor.
		 * @param _width The row width in pixels.
		 * @param text The content string.
		 */
		public function MenuRow(_width:Number, text:String, tableW:String) {
			
			this.myText = text;
			this.myTableText = tableW;
			
			this.mouseChildren = false;
			this.focusRect = false;
			
			this.blendMode = BlendMode.MULTIPLY;
			this.cacheAsBitmap = true;
			
			select = this.getChildByName("row_selected") as MovieClip;
			unselect = this.getChildByName("row_unselected") as MovieClip;
			marker = this.getChildByName("marker_mc") as MovieClip;
			unselect.alpha = 0.55;
			select.alpha = 0;
			
			marker.alpha = 0;
			
			tfSel = this.createTextSprite(text);
			tfUnsel = this.createTextSprite(text,0x595959);
			
			tfSel.alpha = 0;
			
//			tfSel.x = 3;
//			tfUnsel.x = 3;
			
			
			select.height = 25;
			unselect.height = 25;
			marker.height = 25;
			
						
			tfSel.y = 3;
			tfUnsel.y = 3;
			
			tfSel.x = _width-tfSel.width-4;
			tfUnsel.x = _width-tfUnsel.width-4;
			
			select.width = _width;
			unselect.width = _width;
			marker.width = _width;
			
			
			tfUnsel.alpha = 0.88;
			
			this.addChild(tfUnsel);
			this.addChild(tfSel);
			
			
			var rect:Rectangle = null;
			
			
			this._maxTextWidth = tfSel.width + 7;
			
			this.addEventListener(MouseEvent.MOUSE_OVER, over);
			this.addEventListener(MouseEvent.MOUSE_OUT,out);
			this.addEventListener(MouseEvent.CLICK, activateMe);
		}
		
		
		private var markerTw:Tween = null;
		
		/**
		 * Highlights the cell.
		 */
		public function set redMarker(v:Boolean) {
			if (v) {
				if (markerTw) markerTw.stop();
				markerTw = new Tween(marker,"alpha",None.easeIn,marker.alpha,1,0.3,true);
			}
			else marker.alpha = 0;
			
			over(null);
		}
		
		
		/**
		 * Activated this row.
		 */
		private function activateMe(evt:MouseEvent):void {
			this._activated = !this._activated;
			this.dispatchEvent(new Event("someoneClicked"));
		}
		
		/**
		 * Is the the line/element activated. Someone clicked on it the first time?
		 */
		public function get activated():Boolean {
			if (marker.alpha >0) return false;
			return this._activated;
		}
		
		/**
		 * Animation tweens.
		 */
		private var tw1:Tween = null;
		private var tw2:Tween = null;
		
		
		/**
		 * Mouse over
		 */
		private function over(evt:MouseEvent):void {
			if (tw1) tw1.stop();
			if (tw2) tw2.stop();
			
						
			tw1 = new Tween(select,"alpha",None.easeIn,select.alpha,1,0.14,true);
			tw2 = new Tween(tfSel,"alpha",None.easeIn,tfSel.alpha,1,0.14,true);
			
		}
		
		/**
		 * Mouse out 
		 */
		private function out(evt:MouseEvent):void {
			
			if (this._activated) return;
			if (marker.alpha == 1) return;
			
			if (tw1) tw1.stop();
			if (tw2) tw2.stop();
			
			tw1 = new Tween(select,"alpha",None.easeIn,select.alpha,0,0.24,true);
			tw2 = new Tween(tfSel,"alpha",None.easeIn,tfSel.alpha,0,0.24,true);
			
		}
		
	}
	
}